/*
  Suits
    0 = Clubs
    1 = Hearts
    2 = Spades
    3 = Diamonds

  Faces
    0 = Two
    1 = Three
    2 = Four
    3 = Five
    4 = Six
    5 = Seven
    6 = Eight
    7 = Nine
    8 = Ten
    9 = Jack
    10 = Queen
    11 = King
    12 = Ace

  Format
    %f - Single-character face -- 2 3 4 5 6 7 8 9 0 J Q K A
    %F - Short face -- 2 3 4 5 6 7 8 9 10 J Q K A
    %N - Full name -- Two Three Four Five ...
    %s - Single-character suit -- C H S D
    %S - Spelled-out suit -- Clubs Hearts Spades ...
    %h - Numberic HTML-escape suit -- &#9827; &#9829; ...
    %H - Human HTML-escape suit -- &clubs; &hearts; ...
    %u - Unicode suit character -- \u2663 \u2665 ...
*/

SUIT_FORMAT = [["C","Clubs","&#9827;","&clubs;","\u2663"],
               ["H","Hearts","&#9829;","&hearts;","\u2665"],
               ["S","Spades","&#9824;","&spades;","\u2660"],
               ["D","Diamonds","&#9830;","&diams;","\u2666"]];

FACE_FORMAT = [["2","2","Two"],
               ["3","3","Three"],
      	       ["4","4","Four"],
      	       ["5","5","Five"],
      	       ["6","6","Six"],
      	       ["7","7","Seven"],
      	       ["8","8","Eight"],
      	       ["9","9","Nine"],
      	       ["0","10","Ten"],
      	       ["J","J","Jack"],
      	       ["Q","Q","Queen"],
      	       ["K","K","King"],
      	       ["A","A","Ace"]];

FACE_VALUES = [[2],[3],[4],[5],[6],[7],[8],[9],[10],[10],[10],[10],[1,11]];

function BJCollection() {
  this.cards = [];
  this.empty = function() { this.cards = []; };
  this.count = function() { return this.cards.length; }
  this.isEmpty = function() { return (this.count() == 0); };
  this.pop = function(show) {
    if(this.isEmpty()) return null;
    var card = this.cards.shift();
    show ? card.show() : card.hide();
    if(this.onpop) this.onpop(card);
    return card;
  };
  this.push = function(c) { if(c != null) this.cards.push(c); };
  this.each = function(f) {
    for(var i = 0; i < this.cards.length; i++) {
      f.call(this.cards[i],i);
    }
  };
  this.possibles = function(vis) {
    var bits = [];
    this.each(function(){if(!vis||this.shown)bits.push(this.values())});
    var possibles = {};
    (function value_(i,n) {
        if(i >= bits.length) {
          possibles[n] = 1; return;
        }
        for(var h = 0; h < bits[i].length; h++) {
          value_(i+1,n+bits[i][h]);
        }
      })(0,0);
    var sorted = [];
    for(var k in possibles) {
      sorted.push(parseInt(k));
    }
    sorted.sort(function(a,b){return a-b});
    return sorted;
  };
  this.value = function(vis) {
    var possibles = this.possibles(vis);
    for(var i = 1; i < possibles.length; i++) {
      if(possibles[i] > 21) return possibles[i-1];
    }
    return possibles[possibles.length-1];
  };
  this.soft = function(vis) {
    var possibles = this.possibles(vis);
    var soft = 0;
    for(var i = 0; i < possibles.length; i++) {
      if(possibles[i] <= 21) {
        if(soft) return 1;
        soft = 1;
      }
    }
    return 0;
  };
  this.swap = function(i,j) {
    var t = this.cards[i];
    this.cards[i] = this.cards[j];
    this.cards[j] = t;
  };
  this.fill = function(n) {
    for(n = n||1; n > 0; n--) {
      for(var s = 0; s < 4; s++) {
        for(var f = 0; f < 13; f++) {
          this.cards.push(new BJCard(s,f,0));
        }
      }
    }
  };
  this.shuffle = function(n) {
    //Once should be plenty but knock yourself out
    for(n = n||1; n > 0; n--) {
      for(var i = this.cards.length-1; i > 0; i--) {
        this.swap(i,Math.floor(Math.random()*i));
      }
    }
  };
  this.render = function() {
    if(this.wrap) return this.wrap;
    this.wrap = document.createElement('div');
    this.update();
    return this.wrap;
  };
  this.update = function() {
    if(!this.wrap) return;
    while(this.wrap.firstChild) {
      this.wrap.removeChild(this.wrap.firstChild);
    }
    for(var i = 0; i < this.cards.length; i++) {
      this.wrap.appendChild(this.cards[i].render());
    }
    if(this.isEmpty()) return;
    var info = document.createElement('div');
    info.className = "value";
    info.style.float = "left";
    if(this.value(1) == 21 && this.count() == 2) {
      info.textContent = "Blackjack!";
    } else {
      info.textContent = "Value: "+this.value(1)+(this.soft(1)?", Soft":"");
    }
    this.wrap.appendChild(info);
  };
}

function BJCard(suit,face,shown) {
  this.suit = suit;
  this.face = face;
  this.shown = shown;
  this.format = function(s) {
    s = s.replace("%f",FACE_FORMAT[this.face][0]);
    s = s.replace("%F",FACE_FORMAT[this.face][1]);
    s = s.replace("%N",FACE_FORMAT[this.face][2]);
    s = s.replace("%s",SUIT_FORMAT[this.suit][0]);
    s = s.replace("%S",SUIT_FORMAT[this.suit][1]);
    s = s.replace("%h",SUIT_FORMAT[this.suit][2]);
    s = s.replace("%H",SUIT_FORMAT[this.suit][3]);
    s = s.replace("%u",SUIT_FORMAT[this.suit][4]);
    return s;
  };
  this.values = function() {
    return FACE_VALUES[this.face];
  };
  this.render = function() {
    if(this.wrap) return this.wrap;
    this.wrap = document.createElement('div');
    this.wrap.className = "card";
    this.cface = document.createElement('div');
    this.cface.className = "face";
    this.wrap.appendChild(this.cface);
    this.cback = document.createElement('div');
    this.cback.className = "back";
    this.wrap.appendChild(this.cback);
    this.update();
    return this.wrap;
  };
  this.update = function() {
    if(!this.cface || !this.cback) return;
    if(this.shown) {
      this.cback.style.display = "none";
      this.cface.style.display = "block";
    } else {
      this.cface.style.display = "none";
      this.cback.style.display = "block";
    }
    this.cface.className = "face "+(this.suit % 2 == 0 ? "black" : "red");
    this.cface.textContent = this.format("%F%u");
  };
  this.show = function() { this.shown = 1; this.update(); };
  this.hide = function() { this.shown = 0; this.update(); };
  this.flip = function() { this.shown = !this.shown; this.update(); };
}
